#version 400

uniform sampler2D vertexData;
uniform sampler2D triangleData;
uniform ivec3 faces[((triangleCount))];

uniform vec3 lightPosition;
uniform vec3 viewerPosition;

in vec3 vertexPosition;

float infinity = 9000.0; //Infinity is 9000, because otherwise you are over 9000.
int triangleCount = ((triangleCount));
int vertexCount = ((vertexCount));

struct hit {
    bool isHit;
    int index;
    vec3 hitPoint;
};

struct colorResult {
    vec4 color;
    vec3 normal;
};

/**
 * --Task--
 * Implement: Mller-Trumbore ray-triangle intersection algorithm with back face culling.
 * You may want to check this out: https://courses.cs.ut.ee/MTAT.03.015/2017_fall/uploads/Main/Fast-MinimumStorage-RayTriangle-Intersection.pdf
 * This function will get a ray's start position and a direction.
 * Also an array of 3 vertices of the triangle.
 * It should output either the "infinity" value if there is no intersection, or the t of the ray's equation: Start + t * Direction = HitPoint.
 */
float checkItersection(vec3 rayStart, vec3 rayDirection, vec3 triangle[3]) {

    // Implement this method.
	// Comment the important lines in the algorithm.

    return infinity;
}

/**
 * Ray cast function. Takes a start position and a direction.
 * Casts a ray into the scene (ie checks for intersections with all the objects in the scene)
 * Then returns the closest hit point.
 */
hit rayCast(vec3 rayStart, vec3 rayDirection) {
    float closestIntersection = infinity;
    float intersection = infinity;
    int closestIntersectionIndex = -1;
    vec3 triangle[3];
    vec3 vertexIndex;

    for (int i = 0; i < ((triangleCount)); i++) {
        vertexIndex = (vec3(faces[i]) + vec3(0.5)) / float(vertexCount);
        triangle[0] = texture2D(vertexData, vec2(vertexIndex.x)).xyz;
        triangle[1] = texture2D(vertexData, vec2(vertexIndex.y)).xyz;
        triangle[2] = texture2D(vertexData, vec2(vertexIndex.z)).xyz;
        intersection = checkItersection(rayStart, rayDirection, triangle);
        if (intersection < closestIntersection) {
            closestIntersection = intersection;
            closestIntersectionIndex = i;
        }
    }
    if (closestIntersectionIndex > -1) {
        hit rayHit = hit(true, closestIntersectionIndex, rayStart + closestIntersection * rayDirection);

        return rayHit;
    } else {
        hit rayMiss = hit(false, closestIntersectionIndex, vec3(0.0, 0.0, 0.0));

        return rayMiss;
    }
}

/**
 * Given a ray start, ray direction and that ray's first hit point, calculate the color value for that hit point.
 */
colorResult calculateColor(vec3 rayStart, vec3 rayDirection, hit rayHit) {
    vec4 color;
    vec3 hitPoint, normal, lightDirection;

    if (rayHit.isHit) {
        color = texture2D(triangleData, vec2((float(rayHit.index) + 0.5) / float(triangleCount), 0.25));

        /**
         * --Task--
         * Fetch also the normal vector from the data texture.
         * Pixel coordinates are the center values in the texture (0.5; 0.5) is the first pixel for example.
         * Depending on a driver, this may work with (0.0; 0.0) or it may not.
         */
        //normal = ...;
        normal = vec3(1.0, 1.0, 1.0); //Remove this line

        //Just some diffuse and ambient light calculations here...
        lightDirection = lightPosition - rayHit.hitPoint;
        lightDirection = normalize(lightDirection);
        color *= clamp(dot(lightDirection, normal), 0.0, 1.0);
        color += vec4(0.2, 0.2, 0.2, 1.0);
    } else {
        color = vec4(0.0, 0.0, 0.0, 1.0);
    }
    colorResult result = colorResult(color, normal);

    return result;
}

/**
 * Ray tracing. Currently just casts one ray, finds the color for the first intersection and returns it.
 * If you want to bounce the ray, then this is the place to do it.
 */
vec4 rayTrace(vec3 rayStart, vec3 rayDirection) {
    hit rayHit = rayCast(rayStart, rayDirection);
    colorResult result = calculateColor(rayStart, rayDirection, rayHit);
    vec4 color = result.color;

    return color;
}


void main() {
    //Find the rayStart and rayDirection.
    vec3 rayStart = viewerPosition;
    vec3 rayDirection = vec3(vertexPosition.xy, 0.0) - viewerPosition;

    //Shoot the ray into the scene and assign the resulting color for this fragment.
    gl_FragColor = rayTrace(rayStart, rayDirection);

    //You may want to view the data texture data:
    /*
    vec2 uv = gl_FragCoord.xy / vec2(250, 250);
    gl_FragColor = vec4(texture2D(vertexData, uv).xyz / 50.0, 1.0);
    */
}
